<?php
session_start();
if (!isset($_SESSION['admin'])) { header("location:login.php"); exit; }
include 'koneksi.php';
$page = isset($_GET['page']) ? $_GET['page'] : 'home';

?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SIM Sekolah Terpadu</title>
    <link rel="icon" type="image/x-icon" href="logo.jpg">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.0/font/bootstrap-icons.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/animate.css/4.1.1/animate.min.css"/>
    <style>
        body { background: #f4f6f9; font-family: sans-serif; overflow-x: hidden; }
        .sidebar { min-height: 100vh; background: #212529; transition: 0.3s; }
        .nav-link.active { background: #0d6efd; color: white !important; font-weight: bold; border-radius: 5px; }
        .nav-link:hover { color: white !important; background: rgba(255,255,255,0.1); border-radius: 5px; }
    </style>
</head>
<body>
<div class="container-fluid">
    <div class="row">
       <!-- SIDEBAR (FIXED & CLEAN) -->
        <div class="col-md-2 sidebar p-0 animate__animated animate__slideInLeft" id="sidebarMenu">
<!-- HEADER LOGO (PREMIUM) -->
        <div class="text-center pt-4 pb-3 border-bottom border-secondary" style="background: linear-gradient(180deg, #181a1d 0%, #212529 100%);">
            
            <!-- Foto Logo dengan Efek Timbul & Status -->
            <div class="d-inline-block position-relative mb-3">
                <img src="logo.jpg" onerror="this.src='https://via.placeholder.com/80?text=LOGO'" 
                     class="rounded-circle border border-3 border-white shadow-lg" 
                     style="width: 90px; height: 90px; object-fit: cover;">
                
                <!-- Titik Hijau (Indikator Online) -->
                <span class="position-absolute bottom-0 end-0 p-2 bg-success border border-2 border-dark rounded-circle" 
                      style="transform: translate(-5px, -5px);"></span>
            </div>

            <!-- Nama Sekolah -->
            <h5 class="text-white fw-bold mb-1" style="letter-spacing: 1px; font-family: 'Poppins', sans-serif;">
                SMA 1 CONTOH
            </h5>
            
            <!-- Badge Keren -->
            <div class="mt-2">
                <span class="badge bg-primary bg-opacity-10 text-primary border border-primary rounded-pill px-3 py-1">
                    <i class="bi bi-shield-check me-1"></i> Official System
                </span>
            </div>
        </div>
        <div class="p-3">
    <ul class="nav flex-column">

        <!-- 1. DASHBOARD (GLOBAL) -->
        <li class="nav-item mb-1">
            <a class="nav-link text-white-50 <?= ($page == 'home') ? 'active' : '' ?>" href="?page=home">
                <i class="bi bi-speedometer2 me-2"></i> Dashboard
            </a>
        </li>
        
        <!-- 2. DATA MASTER (KHUSUS ADMIN) -->
        <?php if ($_SESSION['role_admin'] == 'Admin') { ?>
            <h6 class="text-uppercase text-white-50 mt-4 mb-2" style="font-size: 11px; font-weight: bold;">
                Data Master
            </h6>
            
            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'siswa' || $page == 'edit_siswa') ? 'active' : '' ?>" href="?page=siswa">
                    <i class="bi bi-people me-2"></i> Data Siswa
                </a>
            </li>
            
            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'sdm' || $page == 'edit_guru') ? 'active' : '' ?>" href="?page=sdm">
                    <i class="bi bi-person-badge me-2"></i> Data Guru
                </a>
            </li>
            
            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'kenaikan') ? 'active' : '' ?>" href="?page=kenaikan">
                    <i class="bi bi-graph-up-arrow me-2"></i> Kenaikan Kelas
                </a>
            </li>
        <?php } ?>

        <!-- 3. AKADEMIK & OPS (ADMIN & GURU) -->
        <?php if ($_SESSION['role_admin'] == 'Admin' || $_SESSION['role_admin'] == 'Guru') { ?>
            <h6 class="text-uppercase text-white-50 mt-4 mb-2" style="font-size: 11px; font-weight: bold;">
                Akademik & Ops
            </h6>

            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'akademik') ? 'active' : '' ?>" href="?page=akademik">
                    <i class="bi bi-journal-bookmark me-2"></i> Input Nilai
                </a>
            </li>

            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'absensi' || $page == 'absensi_rekap') ? 'active' : '' ?>" href="?page=absensi">
                    <i class="bi bi-calendar-check me-2"></i> Absensi
                </a>
            </li>

            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'perpus' || $page == 'edit_buku') ? 'active' : '' ?>" href="?page=perpus">
                    <i class="bi bi-book me-2"></i> Perpustakaan
                </a>
            </li>
            
            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?php echo ($page=='rapor')?'active':''; ?>" href="?page=rapor">
                    <i class="bi bi-printer me-2"></i> Cetak Rapor
                </a>
            </li>

            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?php echo ($page=='jadwal')?'active':''; ?>" href="?page=jadwal">
                    <i class="bi bi-calendar-week me-2"></i> Jadwal Pelajaran
                </a>
            </li>
        <?php } ?>

        <!-- 4. KEUANGAN & ASET (KHUSUS ADMIN) -->
        <?php if ($_SESSION['role_admin'] == 'Admin') { ?>
            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'keuangan' || $page == 'edit_spp') ? 'active' : '' ?>" href="?page=keuangan">
                    <i class="bi bi-wallet2 me-2"></i> Keuangan SPP
                </a>
            </li>

            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'sarpras' || $page == 'edit_barang') ? 'active' : '' ?>" href="?page=sarpras">
                    <i class="bi bi-projector me-2"></i> Sarana Prasarana
                </a>
            </li>
        <?php } ?>

        <!-- 5. DATA SAYA (KHUSUS SISWA) -->
        <?php if ($_SESSION['role_admin'] == 'Siswa') { ?>
            <h6 class="text-uppercase text-white-50 mt-4 mb-2" style="font-size: 11px; font-weight: bold;">
                Data Saya
            </h6>

             <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?php echo ($page=='jadwal')?'active':''; ?>" href="?page=jadwal">
                    <i class="bi bi-calendar-week me-2"></i> Jadwal Pelajaran
                </a>
            </li>
            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'tagihan_siswa') ? 'active' : '' ?>" href="?page=tagihan_siswa">
                    <i class="bi bi-receipt me-2"></i> Tagihan Saya
                </a>
            </li>

            <li class="nav-item mb-1">
                <a class="nav-link text-white-50 <?= ($page == 'nilai_siswa') ? 'active' : '' ?>" href="?page=nilai_siswa">
                    <i class="bi bi-journal-text me-2"></i> Nilai Saya
                </a>
            </li>
        <?php } ?>

    </ul>
</div>
        </div>

        <!-- MAIN CONTENT -->
        <div class="col-md-10 ms-sm-auto px-md-4 py-3 bg-light" id="mainContent" style="min-height: 100vh;">
            <!-- HEADER / NAVBAR -->
            <nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm rounded mb-4 px-3">
                <div class="container-fluid p-0">
                    
                    <!-- BAGIAN KIRI: Tombol Toggle & Judul -->
                    <div class="d-flex align-items-center">
                        <button class="btn btn-light border me-3" type="button" id="toggleSidebar">
                            <i class="bi bi-list fs-5"></i>
                        </button>
                        <h5 class="m-0 text-secondary fw-bold text-uppercase">
                            <?php 
                                // Menampilkan judul sesuai halaman yang dibuka
                                echo isset($_GET['page']) ? ucfirst($_GET['page']) : 'Dashboard'; 
                            ?>
                        </h5>
                    </div>

                    <!-- BAGIAN KANAN: Profil & Dropdown -->
                    <div class="d-flex align-items-center">
                        
                        <!-- 1. Teks Nama & Role (Hanya tampil di layar besar/Laptop) -->
                        <div class="text-end me-3 d-none d-md-block">
                            <h6 class="m-0 fw-bold text-dark" style="font-size: 14px;">
                                <!-- Mengambil nama dari Session, kalau tidak ada pakai 'Administrator' -->
                                <?php echo isset($_SESSION['nama_admin']) ? $_SESSION['nama_admin'] : 'Administrator'; ?>
                            </h6>
                            <small class="text-muted" style="font-size: 12px;">
                                <!-- Mengambil role, default 'Admin Sekolah' -->
                                <?php echo isset($_SESSION['role_admin']) ? $_SESSION['role_admin'] : 'Admin Sekolah'; ?>
                            </small>
                        </div>
                        <!-- 2. Avatar & Dropdown Menu -->
                        <div class="dropdown">
                            <a href="#" class="d-flex align-items-center text-decoration-none" data-bs-toggle="dropdown">
                                <?php
                                    // Ambil foto user yang sedang login
                                    $id_login = $_SESSION['id_user'];
                                    $q_user = mysqli_query($koneksi, "SELECT foto FROM users WHERE id='$id_login'");
                                    $d_user = mysqli_fetch_assoc($q_user);
                                    
                                    // Cek foto ada atau tidak
                                    $path_foto = "assets/img/" . $d_user['foto'];
                                    if (!file_exists($path_foto) || empty($d_user['foto'])) {
                                        // Placeholder jika tidak ada foto
                                        echo '<div class="bg-primary text-white rounded-circle d-flex align-items-center justify-content-center shadow-sm" style="width: 40px; height: 40px;"><i class="bi bi-person-fill fs-5"></i></div>';
                                    } else {
                                        // Foto asli user
                                        echo "<img src='$path_foto' class='rounded-circle shadow-sm' style='width: 40px; height: 40px; object-fit: cover;'>";
                                    }
                                ?>
                            </a>
                            
                            <!-- Isi Dropdown (Tambahkan link ke Pengaturan) -->
                            <ul class="dropdown-menu dropdown-menu-end shadow border-0 mt-2">
                                <li><h6 class="dropdown-header text-uppercase small text-muted">Akun Saya</h6></li>
                                <li>
                                    <!-- Link ke halaman profil -->
                                    <a class="dropdown-item py-2" href="?page=profil">
                                        <i class="bi bi-gear me-2 text-secondary"></i> Pengaturan
                                    </a>
                                </li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger fw-bold py-2" href="proses/act_logout.php" onclick="return confirm('Yakin ingin logout?')"><i class="bi bi-box-arrow-right me-2"></i> Logout</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
            </nav>

            <!-- MEMANGGIL KONTEN -->
            <?php include "konten.php"; ?>
        </div>
    </div>
</div>

<script src="https://code.jquery.com/jquery-3.5.1.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.html5.min.js"></script>
<script src="https://cdn.datatables.net/buttons/2.3.6/js/buttons.print.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
    // Toggle Sidebar
    document.getElementById('toggleSidebar').addEventListener('click', function() {
        var sb = document.getElementById('sidebarMenu');
        var ct = document.getElementById('mainContent');
        sb.classList.toggle('d-none');
        if (sb.classList.contains('d-none')) { ct.classList.remove('col-md-10'); ct.classList.add('col-md-12'); } 
        else { ct.classList.remove('col-md-12'); ct.classList.add('col-md-10'); }
    });

    // DataTables Config
    $(document).ready(function () {
        // Fungsi untuk mengaktifkan Datatable + Excel
        function dt(id) { 
            if($(id).length) { 
                $(id).DataTable({
                    dom: 'Bfrtip', 
                    buttons: [
                        {
                            extend: 'excelHtml5',
                            text: '<i class="bi bi-file-earmark-excel"></i> Export Excel',
                            className: 'btn btn-success btn-sm'
                        }
                    ], 
                    language: {
                        search: "Cari:",
                        paginate: {next:">",previous:"<"}
                    }
                }); 
                // Rapikan posisi tombol
                setTimeout(function(){ 
                    $(id+'_wrapper .dt-buttons').css({'display':'inline-block','margin-left':'10px'}); 
                    $(id+'_filter').css({'float':'right'}); 
                },100);
            } 
        }
        // Inisialisasi semua tabel yang ada
        dt('#tabelTransaksi'); 
        dt('#tabelSiswa'); 
        dt('#tabelGuru'); 
        dt('#tabelNilai'); 
        dt('#tabelBuku'); 
        dt('#tabelBarang');
    });
</script>
</body>
</html>